/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.level.items;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class TreasureChestBlockItem
extends BlockItem {
    public TreasureChestBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public boolean canFitInsideContainerItems() {
        return false;
    }

    public void displayTreasureChestContents(ItemStack stack, Item.TooltipContext context, @Nullable Player player, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        boolean isOwner;
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data == null || data.isEmpty()) {
            return;
        }
        CompoundTag tag = data.copyTag();
        UUID ownerUUID = null;
        if (tag.hasUUID("OwnerUUID")) {
            ownerUUID = tag.getUUID("OwnerUUID");
        }
        boolean bl = isOwner = player != null && ownerUUID != null && player.getUUID().equals(ownerUUID);
        if (isOwner) {
            if (tag.contains("Items", 9)) {
                ListTag itemsList = tag.getList("Items", 10);
                int displayedTypes = 0;
                for (int i = 0; i < itemsList.size(); ++i) {
                    CompoundTag itemTag = itemsList.getCompound(i);
                    if (!itemTag.contains("id", 8)) continue;
                    try {
                        ItemStack item;
                        int count = itemTag.contains("Count", 3) ? itemTag.getInt("Count") : 1;
                        Optional parse = ItemStack.parse((HolderLookup.Provider)context.registries(), (Tag)itemTag);
                        if (!parse.isPresent() || (item = (ItemStack)parse.get()).isEmpty()) continue;
                        ++displayedTypes;
                        MutableComponent itemText = item.getHoverName().copy();
                        itemText.append(" x").append(String.valueOf(count));
                        tooltip.add((Component)itemText);
                        continue;
                    }
                    catch (Exception count) {
                        // empty catch block
                    }
                }
                int remainingTypes = 0;
                for (int i = displayedTypes; i < itemsList.size(); ++i) {
                    CompoundTag itemTag = itemsList.getCompound(i);
                    if (!itemTag.contains("id", 8)) continue;
                    ++remainingTypes;
                }
                if (remainingTypes > 0) {
                    tooltip.add((Component)Component.translatable((String)"container.shulkerBox.more", (Object[])new Object[]{remainingTypes}).withStyle(ChatFormatting.ITALIC));
                }
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"block.rottencreatures.treasure_chest.hidden_contents").withStyle(ChatFormatting.GRAY));
        }
    }
}

